// Tracker.cpp: implementation of the Tracker class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SonarSystem.h"
#include "Tracker.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Tracker::Tracker()
{
	initTracker();
}

void Tracker::initTracker()
{
	LogNum = 0; // for testing only
	
	int i;
	

	trackerOn	= false;
	algorithm	= 0;

	alpha		= 0.5;
	beta		= 0.5;
	gate		= 2;
	initGate	= 4;
	probDetect	= 0.95;
	extraneousDetect = 0.5;

	countEchoes = 0;
	countTracks = 0;
	countPings  = 0;
	countLive	= 0;
	
	for (i=0;i<MAX_ECHOES;i++)	
	{
		echoList[i].classification = NOT_VALID;
		echoList[i].confidence = NOT_VALID;
		echoList[i].correlation = NOT_VALID;
		echoList[i].echoNumber = NOT_VALID;
		echoList[i].pingNumber = NOT_VALID;
		echoList[i].range = NOT_VALID;
		echoList[i].targetStrength = NOT_VALID;
		echoList[i].trackAssociation = NOT_VALID;
	}

	for (i=0;i<MAX_TRACKS;i++)
	{
		//init index of live tracks...
		indexOfLiveTracks[i] = NOT_VALID;	

		// init tracks for general storage
		tracks[i].setTrack(NOT_VALID, NOT_VALID, false, NOT_VALID, 
						NOT_VALID,  NOT_VALID, NOT_VALID, NOT_VALID);

		//init track array for exporting track to algorithms...
		export[i].setTrack(NOT_VALID, NOT_VALID, false, NOT_VALID, 
						NOT_VALID,  NOT_VALID, NOT_VALID, NOT_VALID);		
	}
	/**/
}

Tracker::~Tracker(){}


//////////////////////////////////////////////////////////////////////
// Test Stuff
//////////////////////////////////////////////////////////////////////
void Tracker::logToFile(int n, char * output)
{
	char fileName[] = "trackerLogFile.txt";
	ofstream outFile(fileName, ios::app);
	outFile<<"Log Number - "<<LogNum++;
	outFile<<"# "<<n<<":  "<<output<<endl;
	outFile.close();
	return;
}

int Tracker::findTracks(int uid) {

	// This is just an example for proof of concept.

	int rtn = (int) gate;
	algorithm = 2;
	associateTracks();
	return (rtn) ;
}

//////////////////////////////////////////////////////////////////////
// Real Stuff
//////////////////////////////////////////////////////////////////////
int Tracker::associateTracks()
{
	// returns 0 if ok 
	int rtn = 1;
	
	algorithm = 0;
	/////////////////////testing///////////////////////
	char fileName[] = "dummyTrackerLogFile.txt";
	ofstream outFile(fileName, ios::app);
	outFile<<"Entered associateTracks"<<endl;
	outFile<<"algorithm = "<<algorithm<<endl;
	outFile.close();
	///////////////////////////////////////////////////

	switch (algorithm) 
	{
		case 0:		// ab
		   rtn = algo_alphaBeta_V1();
			
		   break;

		case 1 :	// ab +  jpda
			rtn = algo_JPDA_V1();
			
			break;

		case 2 :	// nn
			dummyTracker();
			
			break;

	// Need to add more cases for additional algorithms


//		 case default:
			 
			 
			break;
	}


	return 0;

}

//////////////////////////////////////////////////////////////////////
// Real: AlphaBeta
//////////////////////////////////////////////////////////////////////
int Tracker::algo_alphaBeta_V1()
{
	////////////// testing only //////////////////////////////

	alpha = 0.0;					// velocity update scaling parameter
	beta  = 0.0;					// position update scaling parameter
	gate  = 2;	

	///////////////////////////////////////////////////////////


	int currentPing,
		num_tracks = countLive;
	
	currentPing = getCurrentPingNumber();
	// if the first echo is included just initialize...
	// I'm not sure this is logically required - could be left out???
	if (countLive == 0)		// no tracks yet, so each echoes creates a tracks... 
	{
		initialTrackSetup(currentPing);
		return 0;
	}

	else					// ok, so we've already generated some tracks...
	{
		// Associate Echoes
		algo_alphaBeta_V1_association();

		// do prediction...
		algo_alphaBeta_V1_prediction();			
	}

	return 0;
}


//////////////////////////////////////////////////////////////////////
// Real: Helper
//////////////////////////////////////////////////////////////////////
int Tracker::pruneLiveTracks()
{
	int lastFree=0, i;
	bool dead;

	for (i=0;i<countLive;i++)
	{		
		dead = tracks[indexOfLiveTracks[i]].isDone;		
		indexOfLiveTracks[lastFree] = indexOfLiveTracks[i];		
		if (!(dead)) lastFree++;
	}


	for (i=lastFree; i<countLive; i++)	indexOfLiveTracks[i] = NOT_VALID;
	countLive=lastFree;	
	return 0;
}

int Tracker::addTrack()
{
	/* 
	This method "adds" a new track to the array by:
		initializing the new track 
		entering the tracks number in the index of live tracks
		does bookkeeping (increments countLive and countTracks);
	*/

	// need to add check for array overflow...
	if ((countTracks+1)>MAX_TRACKS) return -1;

	// since the tracks is new it must still be live, so add to index of live tracks...
	indexOfLiveTracks[countLive]=countTracks;

	// we know that the track isn't done yet...
	tracks[countTracks].setTrack(NOT_VALID, NOT_VALID, false, 
					NOT_VALID, NOT_VALID, NOT_VALID, NOT_VALID, NOT_VALID);
	// update counts
	countLive++;
	countTracks++;

	return countTracks-1;
}

bool Tracker::addNewEcho(long pingNum, long echoNum)
{
	////////////////// testing /////////////////////
	char msgString[100] = "entered AddNewEchoe (pingNum|echoNum)", pNum[10], eNum[10];
	itoa (pingNum, pNum, 10);
	itoa (echoNum, eNum, 10);

	strcat(msgString, pNum);
	strcat(msgString, "|");
	strcat(msgString, eNum);
	logToFile(0,msgString);
	/////////////////////////////////////////////////
	int location = findEcho(pingNum, echoNum);
	/*if ((echoList[location].pingNumber == pingNum)&&( echoList[location].echoNumber== echoNum))
	{
		// already added this echo
		// might want to do some sort of error handling???...
		return false;
	}*/

	// If this is true then we have a new ping	
	if (echoNum == 0)  
	{
		pingIndex[countPings] = countEchoes;
		countPings++;
	}

	/*else if ((echoList[countEchoes-1].pingNumber)!=pingNum) 
	{
		// Pings should be sequential so something is wrong...
		// might want to do some sort of error handling???...
		return false;
	}*/
	
	// init echo
	echoList[countEchoes].pingNumber = pingNum;
	echoList[countEchoes].echoNumber = echoNum;

	// update countEchoes
	countEchoes++;

	return true;	
}

void Tracker::set_trackerParamAlphaBeta(double alphaIn, double betaIn, long gateIn)
{
	initTracker();
	alpha	= alphaIn;
	beta	= betaIn;
	gate	= gateIn;
}

void Tracker::set_trackerParamJPDA(double alphaIn, double betaIn, double initGateIn, 
								   double probOfDetectIn, double extraneousDetectIn)
{
	initTracker();
	alpha		= alphaIn;
	beta		= betaIn;
	initGate	= initGateIn;

	probDetect			= probOfDetectIn;
	extraneousDetect	= extraneousDetectIn;
}

long Tracker::getTrackAssoc(long pingNum, long echoNum)
{
	return echoList[findEcho(pingNum, echoNum)].trackAssociation;;
}

double Tracker::getAverageTrackTS(long trackNum)
{
	// STUB 2002.07.23
	double total = tracks[trackNum].totalTS;
	int length = (tracks[trackNum].end - tracks[trackNum].start+1);
	return length;
}

bool Tracker::setClassification(long pingNum, long echoNum, long value)
{
	//check to see if the pingNum, and EchoNum are legal and that the echo exists...
	// if not return false;
	int location = findEcho(pingNum, echoNum);
	echoList[location].classification = value;


	/////// testing /////////////
	char fileName[] = "trackerLogFile.txt";
	ofstream outFile(fileName, ios::app);
	outFile	<<"Log Number - "<<LogNum++;
	outFile <<"Ping ("<<(echoList[location].pingNumber)<<", "<<(echoList[location].echoNumber)<<") ";
	outFile	<<"entered setClassifiaction, pingNum = "<<pingNum
			<<", echoNum = "<<echoNum<<", value = "<<value<<", and findEcho calculated "
			<<location<<" for the position of the echo in the list."
			<<endl;

	outFile.close();
	/////////////////////////////

	return true;
}

bool Tracker::setConfidence(long pingNum, long echoNum, float value)
{
	//check to see if the pingNum, and EchoNum are legal and that the echo exists...
	// if not return false;
	int location = findEcho(pingNum, echoNum);
	echoList[location].confidence = value;

	/////// testing /////////////
	char fileName[] = "trackerLogFile.txt";
	ofstream outFile(fileName, ios::app);
	outFile	<<"Log Number - "<<LogNum++;

	outFile <<"Ping ("<<(echoList[location].pingNumber)<<", "
			<<(echoList[location].echoNumber)<<") ";
	outFile	<<"entered setConfidence, pingNum = "<<pingNum
			<<", echoNum = "<<echoNum<<", value = "<<value<<", and findEcho calculated "
			<<location<<" for the position of the echo in the list."
			<<endl;

	outFile.close();
	/////////////////////////////

	return true;
}

bool Tracker::setCorrelation(long pingNum, long echoNum, float value)
{
	//check to see if the pingNum, and EchoNum are legal and that the echo exists...
	// if not return false;
	int location = findEcho(pingNum, echoNum);
	echoList[location].correlation = value;

	/////// testing /////////////
	char fileName[] = "trackerLogFile.txt";
	ofstream outFile(fileName, ios::app);
	outFile	<<"Log Number - "<<LogNum++;

	outFile <<"Ping ("<<(echoList[location].pingNumber)<<", "
			<<(echoList[location].echoNumber)<<") ";
	outFile	<<"entered setCorrelation, pingNum = "<<pingNum
			<<", echoNum = "<<echoNum<<", value = "<<value<<", and findEcho calculated "
			<<location<<" for the position of the echo in the list."
			<<endl;

	outFile.close();
	/////////////////////////////

	return true;
}

bool Tracker::setRange(long pingNum, long echoNum, float value)
{
	//check to see if the pingNum, and EchoNum are legal and that the echo exists...
	// if not return false;
	int location = findEcho(pingNum, echoNum);
	echoList[location].range = value;

	/////// testing /////////////
	char fileName[] = "trackerLogFile.txt";
	ofstream outFile(fileName, ios::app);
	outFile	<<"Log Number - "<<LogNum++;

	outFile <<"Ping ("<<(echoList[location].pingNumber)<<", "
			<<(echoList[location].echoNumber)<<") ";
	outFile	<<"entered setRange, pingNum = "<<pingNum
			<<", echoNum = "<<echoNum<<", value = "<<value<<", and findEcho calculated "
			<<location<<" for the position of the echo in the list."
			<<endl;

	outFile.close();
	/////////////////////////////

	return true;
}

bool Tracker::setTS(long pingNum, long echoNum, float value)
{
	//check to see if the pingNum, and EchoNum are legal and that the echo exists...
	// if not return false;
	int location = findEcho(pingNum, echoNum);
	echoList[location].targetStrength = value;

	/////// testing /////////////
	char fileName[] = "trackerLogFile.txt";
	ofstream outFile(fileName, ios::app);
	outFile	<<"Log Number - "<<LogNum++;

	outFile <<"Ping ("<<(echoList[location].pingNumber)<<", "
			<<(echoList[location].echoNumber)<<") ";
	outFile	<<"entered setTS, pingNum = "<<pingNum
			<<", echoNum = "<<echoNum<<", value = "<<value<<", and findEcho calculated "
			<<location<<" for the position of the echo in the list."
			<<endl;

	outFile.close();
	/////////////////////////////

	return true;
}

int Tracker::findEcho(int pingNum, int echoNum)
{
	/////// testing /////////////
	char fileName[] = "trackerLogFile.txt";
	ofstream outFile(fileName, ios::app);
	outFile	<<"Log Number - "<<LogNum++;
	outFile	<<"entered findEcho, pingNum = "<<pingNum
			<<", echoNum = "<<echoNum<<", and findEcho calculated "
			<<(pingIndex[pingNum]+echoNum)
			<<" for the position of the echo in the list."
			<<endl;

	outFile.close();
	/////////////////////////////	
	
	
	return (pingIndex[pingNum]+echoNum);
}

int Tracker::algo_JPDA_V1()
{
	// stub
	return 0;
}

int Tracker::dumpDataToFile()
{
	char fileName[] = "trackerTestFile.txt";
	ofstream outFile(fileName, ios::app);

	int i, lastPing = -1;
	

	outFile <<"-------------------------------------------------------------------------"<<endl;
	outFile <<"************************  Start Echo Data *************************"<<endl;
	outFile	<<"-------------------------------------------------------------------------"<<endl;
	outFile<<"There should be "<<countEchoes<<" echoes listed:"<<endl;
	for (i=0;i<countEchoes;i++)
	{
		if (lastPing != echoList[i].pingNumber)
		{
			lastPing++;
			outFile<<'\n'<<"Ping# <"<<lastPing<<"> :"<<endl;
		}
		outFile	<<"Position ins Storage = "<<i<<", Ping# = "<<echoList[i].pingNumber<<"Echo# = "<<echoList[i].echoNumber<<"), range = "<<echoList[i].range
				<<", TS = "<<echoList[i].targetStrength<<", class. = "<<echoList[i].classification
				<<", conf. = "<<echoList[i].confidence<<", corr. = "<<echoList[i].correlation
				<<", track = "<<echoList[i].trackAssociation<<endl;

	}


	outFile <<"-------------------------------------------------------------------------"<<endl;
	outFile <<"**************************  Start Ping Index   **************************"<<endl;
	outFile	<<"-------------------------------------------------------------------------"<<endl;
	outFile <<'\n'<<"(Except for the first index, only non-zero indices are printed...)";
	for (i=0;i<MAX_PINGS;i++)
	{
		if ((pingIndex[i] != 0) || (i==0))
			outFile <<'\n'<<"pingIndex["<<i<<"] = "<<pingIndex[i]<<endl;
	}
	
	outFile <<"-------------------------------------------------------------------------"<<endl;
	outFile <<"************************  Start Parameter Setup *************************"<<endl;
	outFile	<<"-------------------------------------------------------------------------"<<endl;
	outFile<<'\n'<<"algorithm = "<<algorithm<<endl;
	outFile<<"alpha = "<<alpha<<" //beta = "<<beta<<" //gate = "<<gate<<endl;
	outFile <<"initGate = "<<initGate<<" //ProbDetect = "<<probDetect
			<<" // extraneous = "<<extraneousDetect<<endl;

	outFile <<" countEchoes ="<<countEchoes<<"  // countTracks ="<<countTracks
			<<"  // countPings ="<<countPings<<"  // countLive ="<<countLive<<endl;


	outFile <<"-------------------------------------------------------------------------"<<endl;
	outFile <<"************************  Start Dump Track Data *************************"<<endl;
	outFile	<<"-------------------------------------------------------------------------"<<endl;


	outFile <<"not implemented yet."<<endl;


	outFile<<"There should be "<<countTracks<<" tracks listed:"<<endl;
	outFile<<countLive<<" of these tracks are live..."<<endl;

	char msgDone;
	int minCount=countTracks +10;

	for (i=0;i<minCount;i++)
	{
		if (tracks[i].isDone) msgDone = 'Y'; else msgDone = 'N';

		outFile	<<"//Track (Track# = "<<i<<"), start = "<<tracks[i].start
				<<", end = "<<tracks[i].end<<", done = "<<(char)msgDone
				<<", TS = "<<tracks[i].totalTS<<", velocity = "<<tracks[i].velocity
				<<", gate_max = "<<tracks[i].gate_max<<", gate_min = "<<tracks[i].gate_min
				<<endl;
		
	}

	outFile <<'\n'<<'\n'<<"................................................................."<<endl;
	outFile	<<"A list what the index of live tracks is pointing at."<<'\n'
			<<"The count for the number of live tracks is "<<countLive<<".  The list follows:"<<endl;

	for (i=0;i<MAX_TRACKS;i++)
	{
		outFile <<"indexOfLiveTracks["<<i<<"] = "<<indexOfLiveTracks[i]<<endl;

	}

	outFile.close();
	return 0;
}

long Tracker::testTracker(short testToRun)
{
	switch (testToRun) 
	{
	case 0:		// what's in the data store...
		return dumpDataToFile();
		
		break;
		
	case 1 :	// 
		
		
		break;
		
	case 2 :	// nn
		//	rtn = nearestNeighbor();
		
		break;
	}
	return -1;
}

int Tracker::initialTrackSetup(int pingNum)
{
	// STUB REB 2002.07.28
	int index, trackNum, rtv = 0;
	double range;

	for (index = findEcho(pingNum,0); index<countEchoes ; index++)
	{	
		range = echoList[index].range;
		trackNum = addTrack();
		tracks[trackNum].setTrack(pingNum, pingNum, false, 0, 0, range, 0, 0);
		echoList[index].trackAssociation = trackNum;
		rtv++;
	}

	return rtv;
}

int Tracker::dummyTracker()
{
	/*	this is purely for testing purposes
		REB - STUB - 2002.07.28

		Algorithm - Link all echoes with the same echo number.
	*/
	//////////////////////////////////////////////////////
	char fileName[] = "dummyTrackerLogFile.txt";
	ofstream outFile(fileName, ios::app);
	outFile<<"StartLog"<<endl;

	int currentPing, 
		numEchoes, 
		index, 
		lastContinued, 
		position_old, 
		position_new;

	bool needsPruning = false;

	// get the current echo number
	currentPing = countPings-1 ;
	///////////////// let's make it even simpler ///////////

	int anzahlEchoes = countEchoes - findEcho(currentPing, 0);
	int newTrackNum;
	outFile <<"-> currentPing = "<<currentPing
			<<"//countPings = "<<countPings
			<<"//anzahlEchoes = "<<anzahlEchoes<<endl;

	for (index=0; index<anzahlEchoes;index++)
	{
		
		
		// add Track
		
		
		// if there isn't a track already...
		if (currentPing == 0) // first ping
		{
			newTrackNum = index;
		}

		// if there is already a track from the previous ping for that echo
		else if (((echoList[findEcho(currentPing-1, index)].echoNumber == 
				echoList[findEcho(currentPing, index)].echoNumber)) && 
				(((1+(echoList[findEcho(currentPing-1, index)].pingNumber)) ==
				(echoList[findEcho(currentPing, index)].pingNumber))))

		{
			newTrackNum = echoList[findEcho(currentPing-1, index)].trackAssociation;
			
		}
		else
		{
			newTrackNum = addTrack();
			tracks[newTrackNum].start = currentPing;
			tracks[newTrackNum].end   = currentPing;
		}
		// associate echo
		echoList[findEcho(currentPing, index)].trackAssociation = newTrackNum;
		
		// Update Tracks
		tracks[newTrackNum].end = currentPing;

		outFile	<<"Assigned to echo #"<<findEcho(currentPing, index)
				<<" the track#"<<(echoList[findEcho(currentPing, index)].trackAssociation)
				<<endl;
		
	}



	outFile.close();
	return 0;
	///////////////////////////////////////////////////////////


	// get the number of echoes in the current ping
	numEchoes	= countEchoes - findEcho(currentPing,0);

	outFile<<"currentPing = "<<currentPing<<endl;

	// No sense tracking until I have more than 1 ping.
	if (currentPing <= 0) 
	{
		if (currentPing < 0) return 0;

		outFile<<"// initializing tracks for 1st ping containing "<< numEchoes<< " echoes. "<<endl;
		for (index = 0; index<numEchoes ; index++)
		{
			echoList[index].trackAssociation = addTrack();

			outFile <<"echo #"<<index<<".trackAssociation = "
					<<(echoList[index].trackAssociation)
					<<", CurrentPing = "<<currentPing<<", "
					<<tracks[echoList[index].trackAssociation].start
					<<", "<<tracks[echoList[index].trackAssociation].end<<endl;

			tracks[echoList[index].trackAssociation].start	= currentPing;
			tracks[echoList[index].trackAssociation].end	= currentPing;
		}
		return 0;
	}

	// For each track in the list of live tracks, look for one that
	// 
	outFile<<"numEchoes = "<<numEchoes<<endl;

	for (index = 0;index < numEchoes; index ++)
	{
		if ((currentPing-2) >= 0)
			position_old = findEcho(currentPing-2,index);
		else position_old = index;
		position_new = findEcho(currentPing-1,index);

		outFile<<"position_old = "<<position_old<<" // position_new ="<<position_new;

		if (position_new <countEchoes)
		{
			// continue tracks
			
			echoList[position_new].trackAssociation = echoList[position_old].trackAssociation;
			lastContinued = position_old;
			outFile	<<" so continuing the track."<<(echoList[position_new].trackAssociation)
					<<" at echo#"<<position_new<<endl;
		}

		else
		{
			// create new track...
			outFile<<" < countEchoes ("<<countEchoes<<") so create new track..."<<endl;
			echoList[position_new].trackAssociation = addTrack();
		}
	}

	outFile<<"---------------- terminate track that were not continued ---------------"<<endl;

	// terminate tracks that were not continued...

	outFile	<<"looping from Last continued = "<<lastContinued<<" to "
			<<findEcho(currentPing, 0)<<endl;
	
	for (index = lastContinued;index < findEcho(currentPing, 0); index ++)
	{

		outFile<<"terminated track #"<<(echoList[index].trackAssociation)<<endl;

		tracks[echoList[index].trackAssociation].isDone = true;
		needsPruning = true;
	}

	if (needsPruning) pruneLiveTracks();


	// for all echoes in the current ping.


	outFile.close();
	return 0;
}

void Tracker::algo_alphaBeta_V1_association()
{
	bool needsPruning = false;
		
	int i,					// loop index
		j,
		currentPing = getCurrentPingNumber(),
		numEchoes   = getNumEchoesInCurrentPing(),
		index,
		newTrackNum,
		theTrack = NOT_VALID;

	double	distance,
			position,
			windowRadius = 100,   // = gate * range // this value is hardcoded for testing only...
			mn;

	char fileName[] = "trackerTestFile.txt";

	ofstream outFile(fileName, ios::app);
	outFile <<"Start of association for ping #"<<getCurrentPingNumber()
			<<", numEchoes = "<<numEchoes<<endl;

	outFile<<"starting to assign echoes to tracks // currentPing = "<<currentPing<<endl;

	for (i=0;i<countLive;i++)					// cycles through each track
	{
		
		theTrack = indexOfLiveTracks[i];
		mn = REALLY_BIG_NUMBER;

		outFile<<"theTrack = "<<theTrack<<endl;
		for (j=0; j<numEchoes; j++)
		{
			
			outFile	<<"echoList[findEcho(currentPing,j)].trackAssociation = "
					<<(echoList[findEcho(currentPing,j)].trackAssociation)<<endl;

			if ((echoList[findEcho(currentPing,j)].trackAssociation)== NOT_VALID)
			{	
				distance = fabs(echoList[findEcho(currentPing,j)].range - 
								tracks[theTrack].expectedPosition);
				if (distance<mn)
				{
					mn = distance;
					index = j;			// index ends up being the index of the best echoe
				}
				outFile	<<"Entered -> echo = "<<(findEcho(currentPing,j))<<", index = "<<index<<", mn = "
						<<mn<<", distance = "<<distance<<endl;
			}
			outFile<<"Didn't Enter -> echo = "<<(findEcho(currentPing,j))<<", index = "<<index<<", mn = "<<mn<<endl;
			
		}

		if (mn<=windowRadius)
		{
			outFile<<'\n'<<"Associating echoes w/ tracks"<<endl;
			// associate track since w/in radius
				// set the next position to that of the echoes
			tracks[theTrack].currentPosition =  echoList[findEcho(currentPing, index)].range;
				// extend the track
			tracks[theTrack].end = currentPing;
				// mark the echo as assigned to the right track
			echoList[findEcho(currentPing, index)].trackAssociation = theTrack;

		}
		else 
		{
			// no echo found for this track - the line ends here.
			if ((tracks[theTrack].end)!=currentPing)
			{
				tracks[theTrack].isDone = true; //mark the track as done
				needsPruning = true;			//set a flag "needsPruning"
			}
		}
	}

	// Bookkeeping:  weed out track that are done...
	if (needsPruning) pruneLiveTracks();

	// Create new tracks for all unassigned echoes
	for (j=0; j<numEchoes; j++)
	{
		if ((echoList[findEcho(currentPing,j)].trackAssociation)== NOT_VALID)
		{
			newTrackNum = addTrack();
			// associates echo with new track...
			echoList[findEcho(currentPing,j)].trackAssociation = newTrackNum;
			// sets up new track...
			position = echoList[findEcho(currentPing,j)].range;
			tracks[newTrackNum].setTrack(currentPing, currentPing, false, NOT_VALID, 
											position, NOT_VALID, NOT_VALID, NOT_VALID);			
		}
	}
	return;
}


int Tracker::getCurrentPingNumber()
{
	int current;
	current = countPings-1;   // -1 is returned if no ping have been collected
	return current;
}

int Tracker::getNumEchoesInCurrentPing()
{
	int numEchoes, currentPing;
	currentPing = getCurrentPingNumber();
	numEchoes	= countEchoes - findEcho(currentPing,0)+1;
	return numEchoes;
}

void Tracker::algo_alphaBeta_V1_prediction()
{
	//
	int i,
		theTrack;

	double error;

	for (i=0; i<countLive ; i++)
	{
		theTrack = indexOfLiveTracks[i];
		error = tracks[theTrack].currentPosition  - tracks[theTrack].expectedPosition;

		tracks[theTrack].velocity = tracks[theTrack].velocity + ( alpha * error);

		tracks[theTrack].expectedPosition = tracks[theTrack].expectedPosition + 
				 tracks[theTrack].velocity + (beta * error);
	}
	return;
}
